<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="/favicon.ico">

    <title>{{.Product}} :: Dashboard </title>

    <!-- Bootstrap core CSS -->
    <link href="/css/bootstrap.min.css" rel="stylesheet">

    <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
    <link href="/css/ie10-viewport-bug-workaround.css" rel="stylesheet">

    <!-- Custom styles for this template -->
    <link href="/css/dashboard.css" rel="stylesheet">

    <!-- Just for debugging purposes. Don't actually copy these 2 lines! -->
    <!--[if lt IE 9]><script src="../../assets/js/ie8-responsive-file-warning.js"></script><![endif]-->
    <script src="/js/ie-emulation-modes-warning.js"></script>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
  </head>

  <body>

  <nav class="navbar navbar-inverse navbar-fixed-top">
    <div class="container-fluid">
      <div class="navbar-header">
        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
          <span class="sr-only">Toggle navigation</span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
          <span class="icon-bar"></span>
        </button>
        <a class="navbar-brand" href="#">{{.Product}}</a>
      </div>
      <div id="navbar" class="navbar-collapse collapse">

        <ul class="nav navbar-nav navbar-right">
          <li><a href="/dashboard/domains">Domains</a></li>
          <li><a href="/dashboard/users">Manage Users</a></li>
          <li><a href="/dashboard/logs">Log Files</a></li>
          <li><a href="/logout">Logout</a></li>
        </ul>
        <form class="navbar-form navbar-right"  action="/dashboard/logs">
          <input type="text" name="searchtext" class="form-control" placeholder="Search file...">
        </form>
      </div>
    </div>
  </nav>

  <div class="container-fluid">
    <div class="row">
      <div class="col-sm-3 col-md-2 sidebar">
	      <ul class="nav nav-sidebar">
          <li><a href="/dashboard/domains">Domains</a></li>
          <li><a href="/dashboard/users">Manage Users</a></li>
          <li class="active"><a href="/dashboard/logs">Log Files</a></li>
        </ul>
        <ul class="nav nav-sidebar">
          <li><a href="/logout">Logout</a></li>
        </ul>
      </div>
      
      <div class="col-sm-9 col-sm-offset-3 col-md-10 col-md-offset-2 main">
        <h2 class="sub-header">
          <span>Log Files</span> 
        </h2>
        <div class="table-responsive">

        {{ if .LogFiles }}
          <table class="table table-striped">
            <thead>
              <tr>
                <th>File</th>
                <th>Lenght</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>

            {{ range .LogFiles }}
              <tr>
                <td>{{ .FileName }}</td>
                <td>{{ .Size }}</td>
                <td>
                  <a href="/dashboard/logs/view?file={{ .FileName }}&length=10"><span style="font-size: 18px;" class="glyphicon glyphicon-eye-open">10</span></a>
                  &nbsp;&nbsp;&nbsp;&nbsp;
                  <a href="/dashboard/logs/view?file={{ .FileName }}&length=100"><span style="font-size: 18px;" class="glyphicon glyphicon-eye-open">100</span></a>
                  &nbsp;&nbsp;&nbsp;&nbsp;
                  <a href="/dashboard/logs/view?file={{ .FileName }}&length=1000"><span style="font-size: 18px;" class="glyphicon glyphicon-eye-open">1000</span></a>
                </td>
              </tr> 
            {{end}} 
          </tbody>
        </table>

        {{else}}
          {{ if .CustomValue }}
              <b>{{ .CustomName }}</b>
              <hr>
              {{ .CustomValue }}
            {{else}}
              No active logfiles.
            {{end}}
        {{end}} 

        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap core JavaScript
  ================================================== -->
  <!-- Placed at the end of the document so the pages load faster -->
  <script src="/js/jquery.min.js"></script>
  <script>window.jQuery || document.write('<script src="/js/jquery.min.js"><\/script>')</script>
  <script src="/js/bootstrap.min.js"></script>
  <!-- Just to make our placeholder images work. Don't actually copy the next line! -->
  <script src="/js/holder.min.js"></script>
  <!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
  <script src="/js/ie10-viewport-bug-workaround.js"></script>
  </body>
</html>
