#!/bin/sh

# Expected env:
#   zonedir (where to store .db)
#   master (primary NS IP)
#   domain (domain name)
#   username (domain owner name on primary NS)
#   body (full zone config, optional)

if [ -n "${body}" ] && [ -n "${zonedir}" ] && [ -n "${domain}" ]; then
    ZONEFILE="${zonedir}/${domain}.db"
    TMPFILE="${ZONEFILE}.$$"

    umask 077
    mkdir -p "${zonedir}" || exit 1

    # atomic write
    printf '%s' "${body}" > "${TMPFILE}" || exit 1
    mv -f "${TMPFILE}" "${ZONEFILE}" || exit 1
    echo "Zone ${domain} stored in ${zonedir}"
fi

# ... existing dns_write_post.sh logic, if any ...
